# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-04-16 12:12
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import passerelle_reunion_fsn.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0018_smslog'),
    ]

    operations = [
        migrations.CreateModel(
            name='DSDossier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ds_id', models.CharField(max_length=256)),
                ('ds_state', models.CharField(max_length=256)),
                ('csv_file', models.FileField(upload_to=passerelle_reunion_fsn.models.csv_file_location)),
                ('csv_filename', models.CharField(max_length=256)),
                ('last_update_datetime', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Entreprise',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code_application', models.CharField(max_length=20)),
                ('sequence', models.CharField(max_length=16)),
                ('periode', models.CharField(max_length=35)),
                ('siren', models.CharField(max_length=11)),
                ('nom1', models.CharField(blank=True, max_length=35)),
                ('nom2', models.CharField(blank=True, max_length=35)),
                ('nb_salarie', models.CharField(max_length=2)),
                ('rue', models.CharField(blank=True, max_length=35)),
                ('boite_postale', models.CharField(blank=True, max_length=10)),
                ('code_postale', models.CharField(blank=True, max_length=10)),
                ('ville', models.CharField(blank=True, max_length=35)),
                ('code_pays', models.CharField(max_length=2)),
                ('region', models.CharField(max_length=3)),
                ('iban', models.CharField(max_length=34)),
                ('montant', models.FloatField()),
                ('devise', models.CharField(max_length=3)),
                ('nom_demandeur', models.CharField(blank=True, max_length=35)),
                ('prenom_demandeur', models.CharField(blank=True, max_length=35)),
                ('qualite', models.CharField(blank=True, max_length=35)),
                ('tel', models.CharField(blank=True, max_length=30)),
                ('courriel', models.CharField(blank=True, max_length=241)),
                ('last_update_datetime', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='FSNReunionConnector',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                ('api_url', models.URLField(max_length=400, verbose_name='DS API URL')),
                ('token', models.CharField(max_length=256, verbose_name='DS token')),
                ('demarche_number', models.IntegerField(verbose_name='Demarche number')),
                ('instructeur_id', models.CharField(blank=True, help_text='Region identifier for this case', max_length=256, verbose_name='Instructeur identifier')),
                ('users', models.ManyToManyField(blank=True, related_name='_fsnreunionconnector_users_+', related_query_name='+', to='base.ApiUser')),
            ],
            options={
                'verbose_name': 'FSN Reunion',
            },
        ),
        migrations.AddField(
            model_name='entreprise',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='passerelle_reunion_fsn.FSNReunionConnector'),
        ),
        migrations.AddField(
            model_name='dsdossier',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dossiers', to='passerelle_reunion_fsn.FSNReunionConnector'),
        ),
        migrations.AlterUniqueTogether(
            name='entreprise',
            unique_together=set([('resource', 'siren'), ('resource', 'sequence')]),
        ),
        migrations.AlterUniqueTogether(
            name='dsdossier',
            unique_together=set([('resource', 'ds_id')]),
        ),
    ]
