from django.conf.urls import include, url
from django.contrib.auth.decorators import login_required

from passerelle.urls_utils import decorated_includes, required, app_enabled

from .views import *


urlpatterns = [
    url(r'^(?P<slug>[\w,-]+)/communes$', CommunesView.as_view(), name='montpellier-sig-communes'),
    url(r'^(?P<slug>[\w,-]+)/voies/(?P<insee>\d+)$', VoiesView.as_view(), name='montpellier-sig-voies'),
    url(
        r'^(?P<slug>[\w,-]+)/voies/(?P<insee>\d+)/(?P<nom_rue>[\w ]+)/numero$',
        VoiesCommuneView.as_view(),
        name='montpellier-voies-commune',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/voiecommune/(?P<nom_rue>[\w ]+)$',
        VoieCommuneView.as_view(),
        name='montpellier-sig-voiecommune',
    ),
    url(r'^(?P<slug>[\w,-]+)/reverse$', AdresseView.as_view(), name='montpellier-sig-adresse'),
    url(
        r'^(?P<slug>[\w,-]+)/quartier/(?P<insee>\d+)/(?P<nom_rue>[\w ]+)/(?P<numero>\d+)/$',
        DistrictView.as_view(),
        name='montpellier-sig-district',
    ),
    url(r'^(?P<slug>[\w,-]+)/viewer/$', ViewerUrlView.as_view(), name='montpellier-sig-viewer'),
]
