# passerelle-montpellier-encombrants
# Copyright (C) 2015  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.conf.urls import include, url
from passerelle.urls_utils import decorated_includes, required, app_enabled
from django.contrib.auth.decorators import login_required

from .views import *

public_urlpatterns = [
    url(r'^(?P<slug>[\w,-]+)/$', EncombrantsManagementDetailView.as_view(),
        name='montpellier-encombrants-view'),
    url(r'^(?P<slug>[\w,-]+)/available/(?P<insee>\d+)$', AvailableDaysView.as_view(),
        name='montpellier-encombrants-available-days'),
]

management_urlpatterns = [
    url(r'^add$', EncombrantsManagementCreateView.as_view(),
        name='montpellier-encombrants-add'),
    url(r'^(?P<slug>[\w,-]+)/edit$', EncombrantsManagementUpdateView.as_view(),
        name='montpellier-encombrants-edit'),
    url(r'^(?P<slug>[\w,-]+)/delete$', EncombrantsManagementDeleteView.as_view(),
        name='montpellier-encombrants-delete'),
    url(r'^sectors/$', SectorListView.as_view(),
        name='montpellier-encombrants-sector-listing'),
    url(r'^sectors/add$', SectorCreateView.as_view(),
        name='montpellier-encombrants-sector-add'),
    url(r'^sectors/(?P<pk>[\w,-]+)/$', SectorUpdateView.as_view(),
        name='montpellier-encombrants-sector-update'),
    url(r'^sectors/(?P<pk>[\w,-]+)/delete$', SectorDeleteView.as_view(),
        name='montpellier-encombrants-sector-remove'),
    url(r'^communes/$', CommuneListView.as_view(),
        name='montpellier-encombrants-commune-listing'),
    url(r'^communes/add$', CommuneCreateView.as_view(),
        name='montpellier-encombrants-commune-add'),
    url(r'^communes/(?P<pk>[\w,-]+)/edit$', CommuneUpdateView.as_view(),
        name='montpellier-encombrants-commune-edit'),
    url(r'^communes/(?P<pk>[\w,-]+)$', CommuneView.as_view(),
        name='montpellier-encombrants-commune-view'),
    url(r'^communes/(?P<pk>[\w,-]+)/streets$', StreetEditView.as_view(),
        name='montpellier-encombrants-commune-streets-edit-view'),
    url(r'^communes/(?P<pk>[\w,-]+)/delete$', CommuneDeleteView.as_view(),
        name='montpellier-encombrants-commune-remove'),
    url(r'^collectdays/$', CollectDayListView.as_view(),
        name='montpellier-encombrants-collectday-listing'),
    url(r'^collectdays/add$', CollectDayCreateView.as_view(),
        name='montpellier-encombrants-collectday-add'),
    url(r'^collectdays/(?P<pk>[\w,-]+)/delete$', CollectDayDeleteView.as_view(),
        name='montpellier-encombrants-collectday-remove'),
]

urlpatterns = required(
    app_enabled('passerelle_montpellier_encombrants'), [
        url(r'^montpellier-encombrants/', include(public_urlpatterns)),
        url(r'^manage/montpellier-encombrants/',
            decorated_includes(login_required, include(management_urlpatterns))),
    ]
)
