# passerelle-montpellier-encombrants
# Copyright (C) 2015  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.core.urlresolvers import reverse
from django.db import models
from django.utils import six
from django.utils.translation import ugettext_lazy as _

from passerelle.base.models import BaseResource

class EncombrantsManagement(BaseResource):
    category = _('Business Process Connectors')

    class Meta:
        verbose_name = 'Gestion des encombrants Montpellier'

    @classmethod
    def get_icon_class(cls):
        return 'ressources'

    @classmethod
    def get_verbose_name(cls):
        return cls._meta.verbose_name

    def get_absolute_url(self):
        return reverse('montpellier-encombrants-view', kwargs={'slug': self.slug})

    @classmethod
    def get_add_url(cls):
        return reverse('montpellier-encombrants-add')


@six.python_2_unicode_compatible
class Sector(models.Model):
    contact_email = models.CharField(max_length=1024, blank=True,
                    verbose_name=_('Contact Emails'),
                    help_text=_('separated by commas'))

    class Meta:
        verbose_name = _('Sector')

    def __str__(self):
        communes = Commune.objects.filter(sector=self)
        if not communes:
            return '(%s)' % self.id
        return ', '.join([x.name for x in communes])


@six.python_2_unicode_compatible
class Commune(models.Model):
    name = models.CharField(max_length=50, blank=False,
            verbose_name=_('Name'))
    insee = models.CharField(max_length=10, blank=False,
            verbose_name=_('INSEE Code'))
    sector = models.ForeignKey(Sector, verbose_name=_('Sector'))

    def __str__(self):
        return u'%s (%s)' % (self.name, self.insee)


@six.python_2_unicode_compatible
class Street(models.Model):
    commune = models.ForeignKey(Commune)
    name = models.CharField(max_length=128, blank=False,
                        verbose_name=_('Street'))

    def __str__(self):
        return '%s, %s' % (self.name, self.commune)


@six.python_2_unicode_compatible
class CollectDay(models.Model):
    sector = models.ForeignKey(Sector,
            verbose_name=_('Sector'))
    date = models.DateField(verbose_name=_('Date'))

    class Meta:
        ordering = ['date']
        unique_together = ('sector', 'date')

    def __str__(self):
        return '%s: %s' % (self.date, self.sector)
