# Generated by Django 1.11.18 on 2020-05-01 00:17

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0018_smslog'),
    ]

    operations = [
        migrations.CreateModel(
            name='SeisinManagement',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'wsdl_url',
                    models.CharField(
                        help_text='Seisin-by-Email WSDL URL', max_length=128, verbose_name='WSDL URL'
                    ),
                ),
                (
                    'verify_cert',
                    models.BooleanField(default=True, verbose_name='Check HTTPS Certificate validity'),
                ),
                ('username', models.CharField(blank=True, max_length=128, verbose_name='Username')),
                ('password', models.CharField(blank=True, max_length=128, verbose_name='Password')),
                (
                    'keystore',
                    models.FileField(
                        blank=True,
                        help_text='Certificate and private key in PEM format',
                        null=True,
                        upload_to=b'seisin-by-email',
                        verbose_name='Keystore',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_seisinmanagement_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Seisin by Email',
            },
        ),
    ]
