# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2019-03-21 08:20
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0012_job'),
    ]

    operations = [
        migrations.CreateModel(
            name='GLCartaDSCS',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                (
                    'wsdl_base_url',
                    models.URLField(
                        help_text='ex: https://example.net/adscs/webservices/', verbose_name='WSDL Base URL'
                    ),
                ),
                ('username', models.CharField(max_length=64, verbose_name='Username')),
                ('password', models.CharField(max_length=64, verbose_name='Password')),
                ('iv', models.CharField(max_length=16, verbose_name='Initialisation Vector')),
                ('secret_key', models.CharField(max_length=16, verbose_name='Secret Key')),
                ('ftp_server', models.CharField(max_length=128, verbose_name='FTP Server')),
                ('ftp_username', models.CharField(max_length=64, verbose_name='FTP Username')),
                ('ftp_password', models.CharField(max_length=64, verbose_name='FTP Password')),
                ('ftp_client_name', models.CharField(max_length=64, verbose_name='FTP Client Name')),
                ('token_url', models.URLField(max_length=256, verbose_name='Token URL')),
                ('token_authorization', models.CharField(max_length=128, verbose_name='Token Authorization')),
                (
                    'verify_cert',
                    models.BooleanField(default=True, verbose_name='Check HTTPS Certificate validity'),
                ),
                ('users', models.ManyToManyField(blank=True, to='base.ApiUser')),
            ],
            options={
                'verbose_name': 'Cart@DS CS (@ Grand Lyon)',
            },
        ),
    ]
