# Generated by Django 3.2.13 on 2022-05-17 14:40

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Agenda',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('label', models.CharField(max_length=150, verbose_name='Label')),
                ('slug', models.SlugField(max_length=160, unique=True, verbose_name='Identifier')),
            ],
        ),
        migrations.CreateModel(
            name='CheckTypeGroup',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('slug', models.SlugField(max_length=160, unique=True, verbose_name='Identifier')),
                ('label', models.CharField(max_length=150, verbose_name='Label')),
            ],
            options={
                'ordering': ['label'],
            },
        ),
        migrations.CreateModel(
            name='CheckType',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('slug', models.SlugField(max_length=160, verbose_name='Identifier')),
                ('label', models.CharField(max_length=150, verbose_name='Label')),
                (
                    'kind',
                    models.CharField(
                        choices=[('absence', 'Absence'), ('presence', 'Presence')],
                        default='absence',
                        max_length=8,
                        verbose_name='Kind',
                    ),
                ),
                (
                    'pricing',
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='Fixed pricing',
                        max_digits=5,
                        null=True,
                        verbose_name='Pricing',
                    ),
                ),
                (
                    'pricing_rate',
                    models.PositiveIntegerField(
                        blank=True, help_text='Percentage rate', null=True, verbose_name='Pricing rate'
                    ),
                ),
                ('disabled', models.BooleanField(default=False, verbose_name='Disabled')),
                (
                    'group',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='check_types',
                        to='agendas.checktypegroup',
                    ),
                ),
            ],
            options={
                'ordering': ['label'],
                'unique_together': {('group', 'slug')},
            },
        ),
    ]
