# lingo - payment and billing system
# Copyright (C) 2022  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import path, re_path

from . import views

urlpatterns = [
    path('import/', views.config_import, name='lingo-manager-pricing-config-import'),
    path('export/', views.config_export, name='lingo-manager-pricing-config-export'),
    path(
        'criterias/',
        views.criteria_list,
        name='lingo-manager-pricing-criteria-list',
    ),
    path(
        'criteria/category/add/',
        views.criteria_category_add,
        name='lingo-manager-pricing-criteria-category-add',
    ),
    path(
        'criteria/category/<int:pk>/edit/',
        views.criteria_category_edit,
        name='lingo-manager-pricing-criteria-category-edit',
    ),
    path(
        'criteria/category/<int:pk>/delete/',
        views.criteria_category_delete,
        name='lingo-manager-pricing-criteria-category-delete',
    ),
    path(
        'criteria/category/<int:pk>/export/',
        views.criteria_category_export,
        name='lingo-manager-pricing-criteria-category-export',
    ),
    path(
        'criteria/category/<int:pk>/order/',
        views.criteria_order,
        name='lingo-manager-pricing-criteria-order',
    ),
    path(
        'criteria/category/<int:category_pk>/add/',
        views.criteria_add,
        name='lingo-manager-pricing-criteria-add',
    ),
    path(
        'criteria/category/<int:category_pk>/<int:pk>/edit/',
        views.criteria_edit,
        name='lingo-manager-pricing-criteria-edit',
    ),
    path(
        'criteria/category/<int:category_pk>/<int:pk>/delete/',
        views.criteria_delete,
        name='lingo-manager-pricing-criteria-delete',
    ),
    path(
        'criteria/category/<int:pk>/inspect/',
        views.criteria_category_inspect,
        name='lingo-manager-pricing-criteria-category-inspect',
    ),
    path(
        'criteria/category/<int:pk>/history/',
        views.criteria_category_history,
        name='lingo-manager-pricing-criteria-category-history',
    ),
    path(
        'criteria/category/<int:pk>/history/compare/',
        views.criteria_category_history_compare,
        name='lingo-manager-pricing-criteria-category-history-compare',
    ),
    path(
        'agendas/sync/',
        views.agenda_sync,
        name='lingo-manager-agenda-sync',
    ),
    path(
        'agendas/archived/',
        views.agenda_archived_list,
        name='lingo-manager-agenda-archived-list',
    ),
    path(
        'agendas/',
        views.agenda_list,
        name='lingo-manager-agenda-list',
    ),
    path(
        'agenda/<int:pk>/',
        views.agenda_detail,
        name='lingo-manager-agenda-detail',
    ),
    re_path(
        r'^agenda/(?P<slug>[-_a-zA-Z0-9]+)/$',
        views.agenda_detail_redirect,
        name='lingo-manager-agenda-detail-redirect',
    ),
    path(
        'agenda/<int:pk>/export/',
        views.agenda_export,
        name='lingo-manager-agenda-export',
    ),
    path(
        'agenda/<int:pk>/check-options/',
        views.agenda_booking_check_settings,
        name='lingo-manager-agenda-booking-check-settings',
    ),
    path(
        'agenda/<int:pk>/invoicing-options/',
        views.agenda_invoicing_settings,
        name='lingo-manager-agenda-invoicing-settings',
    ),
    path(
        'agenda/<int:pk>/inspect/',
        views.agenda_inspect,
        name='lingo-manager-agenda-inspect',
    ),
    path(
        'agenda/<int:pk>/history/',
        views.agenda_history,
        name='lingo-manager-agenda-history',
    ),
    path(
        'agenda/<int:pk>/history/compare/',
        views.agenda_history_compare,
        name='lingo-manager-agenda-history-compare',
    ),
    path(
        '',
        views.pricing_list,
        name='lingo-manager-pricing-list',
    ),
    path(
        'add/',
        views.pricing_add,
        name='lingo-manager-pricing-add',
    ),
    path(
        '<int:pk>/',
        views.pricing_detail,
        name='lingo-manager-pricing-detail',
    ),
    path(
        '<int:pk>/parameters/',
        views.pricing_parameters,
        name='lingo-manager-pricing-parameters',
    ),
    path(
        '<int:pk>/edit/',
        views.pricing_edit,
        name='lingo-manager-pricing-edit',
    ),
    path(
        '<int:pk>/delete/',
        views.pricing_delete,
        name='lingo-manager-pricing-delete',
    ),
    path(
        '<int:pk>/export/',
        views.pricing_export,
        name='lingo-manager-pricing-export',
    ),
    path(
        '<int:pk>/duplicate/',
        views.pricing_duplicate,
        name='lingo-manager-pricing-duplicate',
    ),
    path(
        '<int:pk>/test-tool/',
        views.pricing_test_tool,
        name='lingo-manager-pricing-test-tool',
    ),
    path(
        '<int:pk>/variable/',
        views.pricing_variable_edit,
        name='lingo-manager-pricing-variable-edit',
    ),
    path(
        '<int:pk>/permissions/',
        views.pricing_permissions_edit,
        name='lingo-manager-pricing-permissions-edit',
    ),
    path(
        '<int:pk>/category/add/',
        views.pricing_criteria_category_add,
        name='lingo-manager-pricing-criteria-category-add',
    ),
    path(
        '<int:pk>/category/<int:category_pk>/edit/',
        views.pricing_criteria_category_edit,
        name='lingo-manager-pricing-criteria-category-edit',
    ),
    path(
        '<int:pk>/category/<int:category_pk>/delete/',
        views.pricing_criteria_category_delete,
        name='lingo-manager-pricing-criteria-category-delete',
    ),
    path(
        '<int:pk>/order/',
        views.pricing_criteria_category_order,
        name='lingo-manager-pricing-criteria-category-order',
    ),
    path(
        '<int:pk>/pricing-options/',
        views.pricing_pricingoptions_edit,
        name='lingo-manager-pricing-pricingoptions-edit',
    ),
    path(
        '<int:pk>/agenda/add/',
        views.pricing_agenda_add,
        name='lingo-manager-pricing-agenda-add',
    ),
    path(
        '<int:pk>/agenda/<int:agenda_pk>/delete/',
        views.pricing_agenda_delete,
        name='lingo-manager-pricing-agenda-delete',
    ),
    path(
        '<int:pk>/billing-date/add/',
        views.pricing_billing_date_add,
        name='lingo-manager-pricing-billing-date-add',
    ),
    path(
        '<int:pk>/billing-date/<int:billing_date_pk>/',
        views.pricing_billing_date_edit,
        name='lingo-manager-pricing-billing-date-edit',
    ),
    path(
        '<int:pk>/billing-date/<int:billing_date_pk>/delete/',
        views.pricing_billing_date_delete,
        name='lingo-manager-pricing-billing-date-delete',
    ),
    path(
        '<int:pk>/matrix/edit/',
        views.pricing_matrix_edit,
        name='lingo-manager-pricing-matrix-edit',
    ),
    re_path(
        r'^(?P<pk>\d+)/matrix/(?P<slug>[-_a-zA-Z0-9]+)/edit/$',
        views.pricing_matrix_edit,
        name='lingo-manager-pricing-matrix-slug-edit',
    ),
    path(
        '<int:pk>/matrix/edit/min/',
        views.pricing_min_matrix_edit,
        name='lingo-manager-pricing-min-matrix-edit',
    ),
    re_path(
        r'^(?P<pk>\d+)/matrix/(?P<slug>[-_a-zA-Z0-9]+)/edit/min/$',
        views.pricing_min_matrix_edit,
        name='lingo-manager-pricing-min-matrix-slug-edit',
    ),
    path(
        '<int:pk>/inspect/',
        views.pricing_inspect,
        name='lingo-manager-pricing-inspect',
    ),
    path(
        '<int:pk>/history/',
        views.pricing_history,
        name='lingo-manager-pricing-history',
    ),
    path(
        '<int:pk>/history/compare/',
        views.pricing_history_compare,
        name='lingo-manager-pricing-history-compare',
    ),
    path('check-types/', views.check_type_list, name='lingo-manager-check-type-list'),
    path(
        'check-type/group/add/',
        views.check_type_group_add,
        name='lingo-manager-check-type-group-add',
    ),
    path(
        'check-type/group/<int:pk>/edit/',
        views.check_type_group_edit,
        name='lingo-manager-check-type-group-edit',
    ),
    path(
        'check-type/group/<int:pk>/unexpected-presence/',
        views.check_type_group_unexpected_presence_edit,
        name='lingo-manager-check-type-group-unexpected-presence-edit',
    ),
    path(
        'check-type/group/<int:pk>/unjustified-absence/',
        views.check_type_group_unjustified_absence_edit,
        name='lingo-manager-check-type-group-unjustified-absence-edit',
    ),
    path(
        'check-type/group/<int:pk>/delete/',
        views.check_type_group_delete,
        name='lingo-manager-check-type-group-delete',
    ),
    path(
        'check-type/group/<int:pk>/export/',
        views.check_type_group_export,
        name='lingo-manager-check-type-group-export',
    ),
    path(
        'check-type/group/<int:group_pk>/add/',
        views.check_type_add,
        name='lingo-manager-check-type-add',
    ),
    path(
        'check-type/group/<int:group_pk>/<int:pk>/edit/',
        views.check_type_edit,
        name='lingo-manager-check-type-edit',
    ),
    path(
        'check-type/group/<int:group_pk>/<int:pk>/delete/',
        views.check_type_delete,
        name='lingo-manager-check-type-delete',
    ),
    path(
        'check-type/group/<int:pk>/inspect/',
        views.check_type_group_inspect,
        name='lingo-manager-check-type-group-inspect',
    ),
    path(
        'check-type/group/<int:pk>/history/',
        views.check_type_group_history,
        name='lingo-manager-check-type-group-history',
    ),
    path(
        'check-type/group/<int:pk>/history/compare/',
        views.check_type_group_history_compare,
        name='lingo-manager-check-type-group-history-compare',
    ),
]
