# lingo - payment and billing system
# Copyright (C) 2023  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import reverse_lazy
from django.views.generic import UpdateView

from lingo.invoicing.models import AppearanceSettings
from lingo.manager.utils import StaffRequiredMixin


class AppearanceSettingsView(StaffRequiredMixin, UpdateView):
    model = AppearanceSettings
    success_url = reverse_lazy('lingo-manager-invoicing-regie-list')
    template_name = 'lingo/invoicing/appearance_settings_form.html'
    fields = '__all__'

    def get_object(self):
        return AppearanceSettings.singleton()


appearance_settings = AppearanceSettingsView.as_view()
