# Generated by Django 3.2.16 on 2023-10-28 08:26

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='PaymentBackend',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('label', models.CharField(max_length=64, verbose_name='Label')),
                (
                    'slug',
                    models.SlugField(
                        help_text='The identifier is used in webservice calls and callback URLs for the payment backend.',
                        unique=True,
                        verbose_name='Identifier',
                    ),
                ),
                (
                    'service',
                    models.CharField(
                        choices=[
                            ('dummy', 'Dummy (for tests)'),
                            ('systempayv2', 'systempay (Banque Populaire)'),
                            ('sips2', 'SIPS (Atos, other countries)'),
                            ('ogone', 'Ingenico (formerly Ogone)'),
                            ('paybox', 'Paybox'),
                            ('payzen', 'PayZen'),
                            ('payfip_ws', 'PayFiP Régie Web-Service'),
                            ('keyware', 'Keyware'),
                            ('mollie', 'Mollie'),
                            ('saga', 'Saga/PayFiP Régie (Futur System)'),
                            ('worldline', 'Atos Worldline'),
                        ],
                        max_length=64,
                        verbose_name='Payment Service',
                    ),
                ),
                (
                    'service_options',
                    models.JSONField(blank=True, default=dict, verbose_name='Payment Service Options'),
                ),
            ],
        ),
    ]
