# hobo - portal to configure and deploy applications
# Copyright (C) 2015-2021 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import io
import os

import requests
from django.core.management.base import BaseCommand

from hobo.applications import installer


class Command(BaseCommand):
    help = '''Install an application from an URL or a local tar file.'''

    def add_arguments(self, parser):
        parser.add_argument('url', metavar='URL', type=str)

    def handle(self, *args, **kwargs):
        url = kwargs['url']
        if url.startswith(('http://', 'https://')):
            resp = requests.get(url, timeout=(5, 5))
            resp.raise_for_status()
            job = installer.check_install(io.BytesIO(resp.content), spool=False)
        elif os.path.isfile(url):
            with open(url, 'rb') as fd:
                job = installer.check_install(fd, spool=False)
        else:
            raise RuntimeError(f'Invalid URL: {url}')

        installer.deploy(job.version, job.application, spool=False)
        print(f'Application {job.application.slug} version {job.version} installed successfully.')
