from django.core.management.base import BaseCommand

from hobo.environment import models


class Command(BaseCommand):
    help = '''Checks if all services are operational'''

    def handle(self, *args, **kwargs):
        errors = []
        for klass in models.AVAILABLE_SERVICES:
            for obj in klass.objects.all():
                res = obj.check_operational(check_metadata=True)
                if res['operational']:
                    if int(kwargs.get('verbosity')) > 1:
                        print(f'{obj.title} at {obj.base_url} is operational')
                    for url in (obj.get_saml_idp_metadata_url(), obj.get_saml_sp_metadata_url()):
                        if url:
                            if res['metadata_operational']:
                                if int(kwargs.get('verbosity')) > 1:
                                    print(f'{obj.title} metadata at {url} is operational')
                            else:
                                errors.append(url)
                                print(
                                    self.style.NOTICE(
                                        f'{obj.title} metadata at {url} is NOT operational. '
                                        'This may be ok if a deployment is still in progress.'
                                    )
                                )
                else:
                    errors.append(obj.base_url)
                    print(
                        self.style.NOTICE(
                            f'{obj.title} at {obj.base_url} is NOT operational '
                            f'(last success: {obj.last_operational_success_timestamp or "never"})'
                        )
                    )
        if errors:
            raise RuntimeError(errors)
