# hobo - portal to configure and deploy applications
# Copyright (C) 2015-2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import base64

from django.http import Http404
from django.utils.encoding import force_str
from rest_framework import permissions
from rest_framework.response import Response
from rest_framework.views import APIView

from hobo.rest_permissions import IsAdminUser, IsAPIClient

from .views import get_app

APIAdminOrAuthUser = (IsAPIClient & IsAdminUser) | ((~IsAPIClient) & permissions.IsAuthenticated)


class ApplicationDownloadAPI(APIView):
    permission_classes = (APIAdminOrAuthUser,)

    def get(self, request, app_slug, version_pk=None):
        try:
            version = get_app(app_slug)
        except Http404:
            return Response({'err': 1, 'err_desc': 'not found'})
        return Response(
            {
                'err': 0,
                'data': {
                    'filename': '%s-%s.tar' % (app_slug, version.number),
                    'content_type': 'application/x-tar',
                    'content': force_str(base64.b64encode(version.bundle.read())),
                },
            }
        )


application_download = ApplicationDownloadAPI.as_view()
