from django.db import connection, migrations
from django.urls import reverse

from hobo.environment.utils import get_local_key


def populate_local_hobo(apps, schema_editor):
    Hobo = apps.get_model('environment', 'Hobo')
    try:
        Hobo.objects.get(local=True)
        return
    except Hobo.DoesNotExist:
        pass

    if hasattr(connection, 'get_tenant'):
        build_absolute_uri = getattr(connection.tenant, 'build_absolute_uri', None)
        if build_absolute_uri:
            Hobo.objects.create(
                secret_key=get_local_key(build_absolute_uri('/')),
                title='Hobo',
                slug='hobo',
                base_url=build_absolute_uri(reverse('home')),
                secondary=False,
                local=True,
            )


def clean_local_hobo(apps, schema_editor):
    Hobo = apps.get_model('environment', 'Hobo')
    Hobo.objects.filter(local=True).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('environment', '0023_populate_local_hobo'),
    ]

    operations = [
        migrations.RunPython(clean_local_hobo, populate_local_hobo),
    ]
