import pytest

from hobo.timeout import Timeout


def test_common_middleware(db, django_app_factory, settings):
    app = django_app_factory(csrf_checks=False)

    resp = app.get('/__ping__/', status=200)
    assert resp.json.get('err') == 0

    resp = app.get('/api/health/', status=200)
    assert 'data' in resp.json

    resp = app.get('/api/health', status=301)
    assert resp.location == '/api/health/'

    for method in (app.post, app.put, app.patch):
        resp = method('/api/health/', status=200)
        assert 'data' in resp.json

        resp = method('/api/health', status=404)
        assert resp.json == {'err': 1, 'err_desc': 'URL must end with a slash.'}


def test_harakiri(db, django_app_factory, settings, caplog):
    caplog.set_level('ERROR')

    app = django_app_factory(csrf_checks=False)

    settings.HARAKIRI = 0.5
    app.get('/api/health/?harakiri_sleep=10', status=200)

    with pytest.raises(Timeout):
        settings.DEBUG = True
        settings.TEMPLATE_VARS = {'site_label': 'Ville de Pioupiou'}
        response = app.get('/api/health/?harakiri_sleep=10', status=200)
        assert 'Ville de Pioupiou' in response
        assert caplog.messages == ['Timeout in health-json:hobo.views.health_json']
        assert 'Harakiri page' in response
        app.get('/api/health/?harakiri_sleep=10&raise=1', status=999)
