# hobo - © Entr'ouvert

import contextlib
import inspect
import logging
import time

from django.conf import settings
from django.shortcuts import render

from hobo.timeout import Timeout, timeout


def harakiri(get_response):
    def middleware(request):
        harakiri_seconds = getattr(settings, 'HARAKIRI', 0)
        if harakiri_seconds > 0:
            context = timeout(seconds=harakiri_seconds)
        else:
            context = contextlib.nullcontext()
        do_raise = 'raise' in request.GET
        try:
            with context:
                response = get_response(request)
                if settings.DEBUG:  # simulate blocking code
                    try:
                        harakiri_sleep = int(request.GET.get('harakiri_sleep', 0))
                    except ValueError:
                        pass
                    else:
                        if harakiri_sleep > 0:
                            time.sleep(harakiri_sleep)
                return response
        except Timeout:
            if do_raise:
                raise
            if getattr(request, 'resolver_match', None):
                function = (
                    inspect.getmodule(request.resolver_match.func).__name__
                    + '.'
                    + request.resolver_match.func.__name__
                )
                msg = f'Timeout in {request.resolver_match.url_name}:{function}'
            else:
                msg = 'Timeout'
            logging.exception(msg)
            context = {'harakiri_seconds': harakiri_seconds}
            response = render(request, 'harakiri.html', context=context)
            return response

    return middleware
