from django.core.management.base import BaseCommand

from hobo.environment import models


class Command(BaseCommand):
    help = '''Checks if all services are operational'''

    def handle(self, *args, **kwargs):
        errors = []
        for klass in models.AVAILABLE_SERVICES:
            for obj in klass.objects.all():
                obj.check_operational()
                if obj.is_operational():
                    if int(kwargs.get('verbosity')) > 1:
                        print(f'{obj.title} at {obj.base_url} is operational')
                else:
                    errors.append(obj.base_url)
                    print(
                        self.style.NOTICE(
                            f'{obj.title} at {obj.base_url} is NOT operational '
                            f'(last success: {obj.last_operational_success_timestamp or "never"})'
                        )
                    )
        if errors:
            raise RuntimeError(errors)
