# Generated by Django 1.11.29 on 2022-01-09 13:16

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('slug', models.SlugField(max_length=100)),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('editable', models.BooleanField(default=True)),
                ('creation_timestamp', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_update_timestamp', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Element',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('type', models.CharField(max_length=25, verbose_name='Type')),
                ('slug', models.SlugField(max_length=500, verbose_name='Slug')),
                ('name', models.CharField(max_length=500, verbose_name='Name')),
                ('cache', models.JSONField(blank=True, default=dict)),
            ],
        ),
        migrations.CreateModel(
            name='Relation',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('auto_dependency', models.BooleanField(default=False)),
                (
                    'application',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to='applications.Application'
                    ),
                ),
                (
                    'element',
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='applications.Element'),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Version',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('bundle', models.FileField(blank=True, null=True, upload_to='applications')),
                ('creation_timestamp', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_update_timestamp', models.DateTimeField(auto_now=True)),
                (
                    'deployment_status',
                    models.JSONField(blank=True, default=dict),
                ),
                (
                    'application',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to='applications.Application'
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='application',
            name='elements',
            field=models.ManyToManyField(
                blank=True, through='applications.Relation', to='applications.Element'
            ),
        ),
    ]
