# hobo - portal to configure and deploy applications © Entr'ouvert

import logging

from django.conf import settings
from django.http import HttpResponse, JsonResponse
from django.utils.deprecation import MiddlewareMixin

WELL_KNOWN_PREFIX = '/.well-known/'
WELL_KNOWN_SETTING = 'WELL_KNOWN'


class WellKnownMiddleware(MiddlewareMixin):
    def process_request(self, request):
        if not request.path.startswith(WELL_KNOWN_PREFIX):
            return None

        if not request.method == 'GET':
            return None

        well_known = getattr(settings, WELL_KNOWN_SETTING, {})
        filename = request.path[len(WELL_KNOWN_PREFIX) :]
        if filename not in well_known:
            return None
        description = well_known[filename]

        content = description.get('content', '')
        if not isinstance(content, str):
            content_type = description.get('content_type', 'application/json')
            try:
                return JsonResponse(content, content_type=content_type, safe=False)
            except Exception:
                logging.exception('JSON serialization of /.well-known/%s failed', filename)
                return JsonResponse({'err': 'JSON serialization failed'})
        else:
            content_type = description.get('content_type', 'text/plain')
            return HttpResponse(content, content_type=content_type)
