# hobo - portal to configure and deploy applications
# Copyright (C) 2015-2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


from django.forms.fields import SplitDateTimeField as DJSplitDateTimeField
from django.forms.widgets import SplitDateTimeWidget as DJSplitDateTimeWidget


class SplitDateTimeWidget(DJSplitDateTimeWidget):
    template_name = 'hobo/splitdatetime.html'

    def __init__(self, *args, **kwargs):
        kwargs['time_format'] = '%H:%M'
        kwargs['date_format'] = '%Y-%m-%d'
        super().__init__(*args, **kwargs)


class SplitDateTimeField(DJSplitDateTimeField):
    widget = SplitDateTimeWidget
