# hobo - portal to configure and deploy applications


def test_json(app, settings):
    app.get('/.well-known/assetlinks.json', status=404)
    settings.WELL_KNOWN = {
        'assetlinks.json': {
            'content': [
                {
                    'a': 'b',
                }
            ]
        }
    }
    resp = app.get('/.well-known/assetlinks.json')
    assert resp.json == [
        {
            'a': 'b',
        }
    ]
    assert resp['content-type'] == 'application/json'
    settings.WELL_KNOWN['assetlinks.json']['content_type'] = 'application/json+entrouvert'
    resp = app.get('/.well-known/assetlinks.json')
    assert resp['content-type'] == 'application/json+entrouvert'

    settings.WELL_KNOWN['assetlinks.json']['content'] = set()
    resp = app.get('/.well-known/assetlinks.json')
    assert resp.json == {'err': 'JSON serialization failed'}


def test_text(app, settings):
    app.get('/.well-known/foobar', status=404)
    settings.WELL_KNOWN = {
        'foobar': {
            'content': 'coucou',
        }
    }
    resp = app.get('/.well-known/foobar')
    assert resp.text == 'coucou'
    assert resp['content-type'] == 'text/plain'

    settings.WELL_KNOWN['foobar']['content_type'] = 'text/xml'
    resp = app.get('/.well-known/foobar')
    assert resp['content-type'] == 'text/xml'
