# Generated by Django 1.11.11 on 2018-03-31 13:34


from django.conf import settings
from django.contrib.postgres.fields import JSONField
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ('fargo', '0001_initial'),
        ('fargo', '0002_auto_20150818_2117'),
        ('fargo', '0003_auto_20150924_1056'),
        ('fargo', '0004_auto_20160212_0936'),
        ('fargo', '0005_auto_20160312_1809'),
        ('fargo', '0006_fill_new_columns'),
        ('fargo', '0007_auto_20160312_1816'),
        ('fargo', '0008_validation_origin'),
        ('fargo', '0009_auto_20160326_2104'),
        ('fargo', '0010_auto_20160413_0809'),
        ('fargo', '0011_userdocument_deletable_by_user'),
        ('fargo', '0012_auto_20161124_0626'),
        ('fargo', '0013_document_mime_type'),
        ('fargo', '0014_auto_20171016_0854'),
        ('fargo', '0015_document_creation_date'),
        ('fargo', '0016_auto_20180330_2248'),
        ('fargo', '0017_auto_20180331_1532'),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Document',
            fields=[
                (
                    'content_hash',
                    models.CharField(
                        max_length=128, serialize=False, verbose_name='content hash', primary_key=True
                    ),
                ),
                ('content', models.FileField(upload_to=b'uploads/', max_length=300, verbose_name='file')),
                ('mime_type', models.CharField(max_length=256, blank=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ('creation_date',),
                'verbose_name': 'document',
                'verbose_name_plural': 'documents',
            },
        ),
        migrations.CreateModel(
            name='Origin',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('label', models.CharField(max_length=80, verbose_name='Label')),
                ('slug', models.SlugField(verbose_name='Slug')),
            ],
        ),
        migrations.CreateModel(
            name='UserDocument',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('filename', models.CharField(max_length=512, verbose_name='filename')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('deletable_by_user', models.BooleanField(default=True, verbose_name='deletable by user')),
                ('title', models.CharField(max_length=200, verbose_name='title', blank=True)),
                ('description', models.TextField(verbose_name='description', blank=True)),
                ('expiration_date', models.DateField(null=True, verbose_name='expiration date', blank=True)),
                (
                    'document',
                    models.ForeignKey(
                        related_name='user_documents',
                        verbose_name='document',
                        to='fargo.Document',
                        on_delete=models.CASCADE,
                    ),
                ),
                (
                    'origin',
                    models.ForeignKey(
                        verbose_name='origin', to='fargo.Origin', null=True, on_delete=models.CASCADE
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        related_name='user_documents',
                        verbose_name='user',
                        to=settings.AUTH_USER_MODEL,
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                'ordering': ('-created', 'user'),
                'verbose_name': 'user document',
                'verbose_name_plural': 'user documents',
            },
        ),
        migrations.CreateModel(
            name='Validation',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                (
                    'content_hash',
                    models.CharField(max_length=128, null=True, verbose_name='content hash', blank=True),
                ),
                ('document_type', models.CharField(max_length=256, verbose_name='document type')),
                ('data', JSONField(null=True, verbose_name='data', default=dict)),
                ('start', models.DateField(verbose_name='start date')),
                ('end', models.DateField(verbose_name='end date')),
                ('creator', models.CharField(max_length=256, verbose_name='creator')),
                ('created', models.DateTimeField(verbose_name='creation date')),
                (
                    'origin',
                    models.ForeignKey(
                        verbose_name='origin', to='fargo.Origin', null=True, on_delete=models.CASCADE
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        verbose_name='user', to=settings.AUTH_USER_MODEL, on_delete=models.CASCADE
                    ),
                ),
            ],
        ),
    ]
