# Generated by Django 4.2.18 on 2025-08-22 09:56

from django.db import migrations


def forward(apps, schema_editor):
    image_class = apps.get_model('gallery', 'Image')

    instances = []
    for instance in image_class.objects.all():
        instance.gallery_temp_id = instance.gallery_id
        instances.append(instance)
    image_class.objects.bulk_update(instances, ['gallery_temp_id'])


class Migration(migrations.Migration):

    dependencies = [
        ('gallery', '0011_image_no_cascade'),
    ]

    operations = [
        migrations.RunPython(forward, reverse_code=migrations.RunPython.noop),
        migrations.RemoveField(
            model_name='image',
            name='gallery',
        ),
    ]
