# Generated by Django 4.2.18 on 2025-07-06 11:23

from django.db import migrations


def forward(apps, schema_editor):
    tile_class = apps.get_model('dashboard', 'Tile')

    instances = []
    for instance in tile_class.objects.all():
        instance.dashboard_temp_id = instance.dashboard_id
        instances.append(instance)
    tile_class.objects.bulk_update(instances, fields=['dashboard_temp_id'])


class Migration(migrations.Migration):

    dependencies = [
        ('data', '0076_convert_feedcell_to_univercell'),
        ('dashboard', '0009_tile_no_cascade'),
    ]

    operations = [
        migrations.RunPython(forward, reverse_code=migrations.RunPython.noop),
        migrations.RemoveField(
            model_name='tile',
            name='dashboard',
        ),
    ]
