# Generated by Django 4.2.18 on 2025-08-24 09:41

from django.db import migrations

from combo.utils.migrations import UnivercellMigration


class MenuUnivercellMigration(UnivercellMigration):
    def __init__(self):
        super().__init__('data', 'combo.data.models.MenuCell')

    def forward_instance(self, new_class, real_class, instance):
        instance.id = None
        instance.__class__ = new_class
        instance.attributes = {
            'title': instance.title,
            'depth': instance.depth,
            'initial_level': instance.initial_level,
            'root_page': instance.root_page_id,
        }
        instance.class_name = self.dotted_class_name
        return instance


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('data', '0080_convert_parentcontentcell_to_univercell'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='MenuCell',
            new_name='OldMenuCell',
        ),
        migrations.CreateModel(
            name='MenuCell',
            fields=[],
            options={
                'verbose_name': 'Menu',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('data.univercell',),
        ),
        migrations.AlterModelTable(
            name='oldmenucell',
            table='data_menucell',
        ),
        MenuUnivercellMigration(),
    ]
