# Generated by Django 1.11.12 on 2018-07-06 11:45

from django.db import migrations, models

from combo.apps.maps.models import ZOOM_LEVELS


class Migration(migrations.Migration):
    dependencies = [
        ('maps', '0006_auto_20180627_0841'),
    ]

    operations = [
        migrations.AddField(
            model_name='maplayer',
            name='properties',
            field=models.CharField(
                blank=True,
                help_text='List of properties to include, separated by commas',
                max_length=500,
                verbose_name='Properties',
            ),
        ),
        migrations.AlterField(
            model_name='map',
            name='initial_state',
            field=models.CharField(
                choices=[
                    ('default-position', 'Centered on default position'),
                    ('device-location', 'Centered on device location'),
                    ('fit-markers', 'Centered to fit all markers'),
                ],
                default='default-position',
                max_length=20,
                verbose_name='Initial state',
            ),
        ),
        migrations.AlterField(
            model_name='map',
            name='initial_zoom',
            field=models.CharField(
                choices=ZOOM_LEVELS, default='13', max_length=2, verbose_name='Initial zoom level'
            ),
        ),
        migrations.AlterField(
            model_name='map',
            name='marker_behaviour_onclick',
            field=models.CharField(
                choices=[('none', 'Nothing'), ('display_data', 'Display data in popup')],
                default='none',
                max_length=32,
                verbose_name='Marker behaviour on click',
            ),
        ),
        migrations.AlterField(
            model_name='map',
            name='max_zoom',
            field=models.CharField(
                choices=ZOOM_LEVELS, default=19, max_length=2, verbose_name='Maximal zoom level'
            ),
        ),
        migrations.AlterField(
            model_name='map',
            name='min_zoom',
            field=models.CharField(
                choices=ZOOM_LEVELS, default='0', max_length=2, verbose_name='Minimal zoom level'
            ),
        ),
        migrations.AlterField(
            model_name='maplayer',
            name='icon_colour',
            field=models.CharField(default='#000000', max_length=7, verbose_name='Icon colour'),
        ),
        migrations.AlterField(
            model_name='maplayer',
            name='marker_colour',
            field=models.CharField(default='#0000FF', max_length=7, verbose_name='Marker or surface colour'),
        ),
    ]
