# Generated by Django 4.2.18 on 2025-08-22 10:06

from django.db import migrations


def forward(apps, schema_editor):
    image_class = apps.get_model('gallery', 'Image')

    instances = []
    for instance in image_class.objects.all():
        instance.gallery_id = instance.gallery_temp_id
        instances.append(instance)
    image_class.objects.bulk_update(instances, ['gallery_id'])


class Migration(migrations.Migration):

    dependencies = [
        ('gallery', '0014_image_gallery'),
    ]

    operations = [
        migrations.RunPython(forward, reverse_code=migrations.RunPython.noop),
    ]
