# Generated by Django 4.2.18 on 2025-07-05 07:23

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('data', '0074_link_cell_title'),
    ]

    operations = [
        migrations.CreateModel(
            name='UniverCell',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('uuid', models.UUIDField(editable=False)),
                ('placeholder', models.CharField(max_length=20)),
                ('order', models.PositiveIntegerField()),
                ('slug', models.SlugField(blank=True, verbose_name='Slug')),
                (
                    'extra_css_class',
                    models.CharField(
                        blank=True,
                        max_length=500,
                        verbose_name='Extra classes for CSS styling',
                    ),
                ),
                (
                    'template_name',
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name='Cell Template',
                    ),
                ),
                (
                    'condition',
                    models.CharField(
                        blank=True,
                        max_length=1000,
                        null=True,
                        verbose_name='Display condition',
                    ),
                ),
                ('public', models.BooleanField(default=True, verbose_name='Public')),
                (
                    'restricted_to_unlogged',
                    models.BooleanField(default=False, verbose_name='Restrict to unlogged users'),
                ),
                ('last_update_timestamp', models.DateTimeField(auto_now=True)),
                ('class_name', models.CharField(max_length=200)),
                ('attributes', models.JSONField(blank=True, default=dict)),
                (
                    'groups',
                    models.ManyToManyField(blank=True, to='auth.group', verbose_name='Roles'),
                ),
                (
                    'page',
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data.page'),
                ),
            ],
            options={
                'abstract': False,
                'unique_together': {('page', 'uuid')},
            },
        ),
        migrations.AddIndex(
            model_name='univercell',
            index=models.Index(fields=['class_name'], name='univercell_class_name_idx'),
        ),
    ]
