# Generated by Django 2.2.19 on 2021-11-04 14:59

from django.db import migrations


def populate_cell_properties(apps, schema_editor):
    Map = apps.get_model('maps', 'Map')
    MapLayerOptions = apps.get_model('maps', 'MapLayerOptions')

    for cell in Map.objects.all():
        for layer in cell.layers.all():
            MapLayerOptions.objects.update_or_create(
                map_cell=cell, map_layer=layer, defaults={'properties': layer.properties}
            )


class Migration(migrations.Migration):
    dependencies = [
        ('maps', '0017_auto_20211104_1559'),
    ]

    operations = [
        migrations.RunPython(populate_cell_properties, migrations.RunPython.noop),
    ]
