# Generated by Django 1.11.18 on 2019-04-26 09:59

import django.db.models.deletion
from django.db import migrations, models
from django.db.models import JSONField


class Migration(migrations.Migration):
    dependencies = [
        ('lingo', '0033_auto_20181204_2241'),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentBackend',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('label', models.CharField(max_length=64, verbose_name='Label')),
                (
                    'slug',
                    models.SlugField(
                        help_text='The identifier is used in webservice calls and callback URLs for the payment backend.',
                        unique=True,
                        verbose_name='Identifier',
                    ),
                ),
                (
                    'service',
                    models.CharField(
                        choices=[
                            (b'dummy', 'Dummy (for tests)'),
                            (b'systempayv2', b'systempay (Banque Populaire)'),
                            (b'sips', 'SIPS (Atos, France)'),
                            (b'sips2', 'SIPS (Atos, other countries)'),
                            (b'spplus', "SP+ (Caisse d'epargne)"),
                            (b'ogone', 'Ingenico (formerly Ogone)'),
                            (b'paybox', 'Paybox'),
                            (b'payzen', 'PayZen'),
                            (b'tipi', 'TIPI'),
                        ],
                        max_length=64,
                        verbose_name='Payment Service',
                    ),
                ),
                (
                    'service_options',
                    JSONField(blank=True, default=dict, verbose_name='Payment Service Options'),
                ),
            ],
        ),
        migrations.AddField(
            model_name='regie',
            name='payment_backend',
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to='lingo.PaymentBackend'
            ),
        ),
    ]
