window.addEventListener('DOMContentLoaded', () => {
  ['toolbar-add', 'toolbar-delete', 'toolbar-options'].forEach((buttonId) => {
    let button = document.getElementById(buttonId)
    button.addEventListener('click', function (ev) {
      const activeElement = document.querySelector('layout-block:state(active)')
      const baseUrl = this.dataset.baseUrl
      if (activeElement) {
        this.dataset.url = `${baseUrl}?active-block-uuid=${activeElement.attributes.uuid.value}`
      } else {
        this.dataset.url = baseUrl + '?active-block-uuid=root'
      }
      window.displayPopup.call(this, ev)
    })
  })
  ;['toolbar-move-before', 'toolbar-move-after',
    'toolbar-cut', 'toolbar-copy', 'toolbar-paste'].forEach((buttonId) => {
    let button = document.getElementById(buttonId)
    button.addEventListener('click', async function () {
      const activeElement = document.querySelector('layout-block:state(active)')
      let activeElementUuid = null; let url = null
      if (activeElement) {
        activeElementUuid = activeElement.attributes.uuid.value
        url = `${this.dataset.baseUrl}?active-block-uuid=${activeElementUuid}`
      } else {
        activeElementUuid = null
        url = this.dataset.baseUrl + '?active-block-uuid=root'
      }
      const resp = await fetch(url, {headers: {'x-requested-with': 'XMLHttpRequest'}})
      const result = await resp.text()
      document.getElementById('layout').outerHTML = result
      if (activeElementUuid) {
        const activeElement = document.querySelector(`layout-block[uuid="${activeElementUuid}"]`)
        if (activeElement) activeElement.active = true
      }
    })
  })

  const searchParams = new URLSearchParams(window.location.search)
  let selectedUuid = searchParams.get('active-block-uuid')
  if (selectedUuid) {
    const activeElement = document.querySelector(`layout-block[uuid="${selectedUuid}"]`)
    if (activeElement) activeElement.active = true
  }
  if (searchParams.get('open-properties') === 'true') {
    document.getElementById('toolbar-options').dispatchEvent(new Event('click'))
  }
})

class LayoutBlock extends HTMLElement {
  constructor () {
    super()
    this._internals = this.attachInternals()
    this._hasClipboardContent = document.getElementById('layout').dataset.hasClipboardContent
    this._toolbarMoveBefore = document.getElementById('toolbar-move-before')
    this._toolbarMoveAfter = document.getElementById('toolbar-move-after')
    this._toolbarAdd = document.getElementById('toolbar-add')
    this._toolbarDelete = document.getElementById('toolbar-delete')
    this._toolbarCut = document.getElementById('toolbar-cut')
    this._toolbarCopy = document.getElementById('toolbar-copy')
    this._toolbarPaste = document.getElementById('toolbar-paste')
    this._toolbarOptions = document.getElementById('toolbar-options')
  }

  get active () {
    return this._internals.state.has('active')
  }

  set active (flag) {
    if (flag) {
      // remove active from other blocks
      document.querySelectorAll('layout-block:state(active)').forEach((el) => { el.active = false })

      // adjust before/after button symbols
      if (this.parentNode.getAttribute('type') === 'row') {
        this._toolbarMoveBefore.classList.remove('vertical')
        this._toolbarMoveAfter.classList.remove('vertical')
      } else {
        this._toolbarMoveBefore.classList.add('vertical')
        this._toolbarMoveAfter.classList.add('vertical')
      }

      // enable/disable before/after buttons
      if (this.previousElementSibling) {
        this._toolbarMoveBefore.removeAttribute('disabled')
      } else {
        this._toolbarMoveBefore.setAttribute('disabled', true)
      }
      if (this.nextElementSibling && this.nextElementSibling.tagName !== 'SPAN') {
        this._toolbarMoveAfter.removeAttribute('disabled')
      } else {
        this._toolbarMoveAfter.setAttribute('disabled', true)
      }

      if (this.getAttribute('container') === 'true') {
        this._toolbarAdd.removeAttribute('disabled')
      } else {
        this._toolbarAdd.setAttribute('disabled', true)
      }

      if (this.getAttribute('container') === 'true' && this._hasClipboardContent) {
        this._toolbarPaste.removeAttribute('disabled')
      } else {
        this._toolbarPaste.setAttribute('disabled', true)
      }

      if (this.parentElement.tagName === 'DIV') {
        this._toolbarDelete.setAttribute('disabled', true)
        this._toolbarCut.setAttribute('disabled', true)
        this._toolbarCopy.setAttribute('disabled', true)
      } else {
        this._toolbarDelete.removeAttribute('disabled')
        this._toolbarCut.removeAttribute('disabled')
        this._toolbarCopy.removeAttribute('disabled')
      }

      if (this.getAttribute('options') === 'true') {
        this._toolbarOptions.removeAttribute('disabled')
      } else {
        this._toolbarOptions.setAttribute('disabled', true)
      }

      // mark as active
      this._internals.states.add('active')
    } else {
      this._internals.states.delete('active')
    }
  }

  connectedCallback () {
    this.addEventListener('click', function (e) {
      this.active = true

      if (e.detail === 2 && !this._toolbarOptions.getAttribute('disabled')) {
        document.getElementById('toolbar-options').dispatchEvent(new Event('click'))
      }
      e.stopPropagation()
    })
  }
}

window.customElements.define('layout-block', LayoutBlock)
