# combo - content management system
# Copyright (C) 2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.utils.translation import gettext_lazy as _


class EventsCalendarCellForm:
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.fields['agendas'].choices = self.get_agenda_choices()

    def get_agenda_choices(self):
        params = {
            'kind': 'events',
        }
        agendas = self.instance.json_request('api/agenda/', params=params)

        page_variables = self.instance.page.get_extra_variables_keys()
        agendas_with_category = [x for x in agendas if x['category']]
        if not agendas_with_category and not page_variables:
            return [(x['id'], x['text']) for x in agendas]

        agenda_options = {}
        for agenda in agendas_with_category:
            category_label = agenda['category_label']
            if category_label not in agenda_options:
                agenda_options[category_label] = [
                    ('category:' + agenda['category'], _('All agendas of category %s') % category_label)
                ]
            agenda_options[category_label].append((agenda['id'], agenda['text']))

        agendas_without_category_options = [(x['id'], x['text']) for x in agendas if not x['category']]
        if agendas_without_category_options:
            agenda_options[_('Misc')] = agendas_without_category_options

        if page_variables:
            agenda_options[_('Page variables')] = [('variable:%s' % x, x) for x in page_variables]

        return list(agenda_options.items())
