# combo - content management system
# Copyright (C) 2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dataclasses

from django import forms

from ..utils.data_sources import DataSource, DataSourceProvider


class DataSourceWidget(forms.Widget):
    template_name = 'combo/layouts/data_source_widget.html'

    def get_context(self, name, value, attrs):
        context = super().get_context(name, value, attrs)
        context['widget']['data_sources'] = DataSourceProvider.get_all
        if value:
            context['widget']['value_option_str'] = '%(provider_id)s:%(service_id)s:%(slug)s' % value
        return context

    def value_from_datadict(self, data, files, name):
        value = super().value_from_datadict(data, files, name)
        if value:
            data_source = DataSource.get_by_option_str(value)
            if data_source:
                value = dataclasses.asdict(data_source)
        return value or {}


class DataSourceField(forms.JSONField):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, widget=DataSourceWidget(), **kwargs)

    def prepare_value(self, value):
        return value or {}  # not converted to string
