# combo - content management system
# Copyright (C) 2017-2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.conf import settings
from django.utils.translation import gettext_lazy as _

from combo.utils.misc import is_portal_agent, is_portal_user


def get_elements_portal_prefix_and_label():
    if is_portal_agent():
        prefix = 'portal-agent-'
        label = _('agent portal')
    elif is_portal_user():
        prefix = ''
        label = ''
    else:
        template_name = settings.TEMPLATE_VARS.get('service_template_name')
        if not template_name:
            prefix = 'portal-generic-'
            label = _('custom portal')
        else:
            prefix = f'{template_name}-portal-'
            label = _('portal %s') % template_name
    return (prefix, label)
