# combo - content management system
# Copyright (C) 2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import include, path, re_path

from combo.urls_utils import decorated_includes, staff_required

from . import manager_views

manager_urls = [
    path('', manager_views.HomeView.as_view(), name='manager-layouts-index'),
    path('add/', manager_views.LayoutAddView.as_view(), name='manager-layouts-add'),
    path('layout/<slug:slug>/', manager_views.LayoutDetailView.as_view(), name='manager-layouts-view'),
    path(
        'layout/<slug:slug>/rename/', manager_views.LayoutRenameView.as_view(), name='manager-layouts-rename'
    ),
    path(
        'layout/by-uuid/<uuid:uuid>/',
        manager_views.LayoutRedirectByUuidView.as_view(),
        name='manager-layouts-view-redirect-by-uuid',
    ),
    path(
        'layout/<slug:slug>/delete/', manager_views.LayoutDeleteView.as_view(), name='manager-layouts-delete'
    ),
    path(
        'layout/<slug:slug>/add-block/',
        manager_views.LayoutAddBlockView.as_view(),
        name='manager-layouts-add-block',
    ),
    path(
        'layout/<slug:slug>/delete-block/',
        manager_views.LayoutDeleteBlockView.as_view(),
        name='manager-layouts-delete-block',
    ),
    path(
        'layout/<slug:slug>/move-block-before/',
        manager_views.LayoutMoveBlockBeforeView.as_view(),
        name='manager-layouts-move-block-before',
    ),
    path(
        'layout/<slug:slug>/move-block-after/',
        manager_views.LayoutMoveBlockAfterView.as_view(),
        name='manager-layouts-move-block-after',
    ),
    path(
        'layout/<slug:slug>/block-options/',
        manager_views.LayoutBlockOptionsView.as_view(),
        name='manager-layouts-block-options',
    ),
]

urlpatterns = [
    re_path(r'^manage/layouts/', decorated_includes(staff_required, include(manager_urls))),
]
