/* global combo_cell_loader, $ */

class ComboEventsCalendar {
  constructor (cell) {
    this.cell = cell
    this.init()

    $(document).on('combo:cell-loaded', (e, targetCell) => {
      if (targetCell !== this.cell) return
      this.init()
    })
  }
  changeWeek (week) {
    $(this.cell)[0].dataset.extraUrlParams = 'week=' + week
    combo_cell_loader({'element': this.cell})
  }
  init () {
    const changeWeekButton = this.cell.querySelectorAll('.events-timetable--change-week')
    changeWeekButton.forEach(button => {
      button.addEventListener('click', () => {
        const week = button.dataset.week
        this.changeWeek(week)
      })
    })

    /*  Dialog with jQuery UI  */
    const events = this.cell.querySelectorAll('.events-timetable--events-list-item')
    events.forEach((event) => {
      const moreInfo = event.querySelector('.events-timetable--event-more')
      const registerLink = event.querySelector('.events-timetable--event-register')
      const dialogEl = event.querySelector('.events-timetable--event-details')
      const eventTitle = event.querySelector('.events-timetable--event-title').innerText
      if (moreInfo) {
        moreInfo.addEventListener('click', (e) => {
          e.preventDefault()
          $(dialogEl).dialog({
            title: eventTitle,
            width: 500,
            modal: true,
          })
          if (registerLink) {
            const registerLinkLabel = registerLink.innerText
            const registerLinkUrl = registerLink.href
            $(dialogEl).dialog('option', 'buttons',
              [
                {
                  text: registerLinkLabel,
                  click: () => {
                    window.location.href = registerLinkUrl
                  },
                  'class': 'submit-button',
                },
              ],
            )
          }
        })
      }
    })
  }
}

document.addEventListener('DOMContentLoaded', () => {
  const eventCalendarCells = document.querySelectorAll('.events-calendar-cell')
  eventCalendarCells.forEach(cell => {
    cell.changeCellWeek = new ComboEventsCalendar(cell)
  })
})
