# Generated by Django 4.2.18 on 2025-08-22 10:00

from django.db import migrations

from combo.utils.migrations import UnivercellMigration


class GalleryUnivercellMigration(UnivercellMigration):
    bulk_create = False

    def __init__(self):
        super().__init__('gallery', 'combo.apps.gallery.models.GalleryCell')

    def forward(self, apps, schema_editor):
        self.image_class = apps.get_model('gallery', 'Image')
        super().forward(apps, schema_editor)

    def forward_instance(self, new_class, real_class, instance):
        old_images = list(self.image_class.objects.filter(gallery_temp_id=instance.id))
        instance = super().forward_instance(new_class, real_class, instance)
        for image in old_images:
            image.gallery_temp_id = instance.id
        self.image_class.objects.bulk_update(old_images, ['gallery_temp_id'])
        return instance


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('data', '0075_univercell'),
        ('gallery', '0012_image_gallery_temp_id'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='GalleryCell',
            new_name='OldGalleryCell',
        ),
        migrations.CreateModel(
            name='GalleryCell',
            fields=[],
            options={
                'verbose_name': 'Gallery',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('data.univercell',),
        ),
        migrations.AlterModelTable(
            name='oldgallerycell',
            table='gallery_gallerycell',
        ),
        GalleryUnivercellMigration(),
    ]
