# Generated by Django 1.11.29 on 2020-11-30 14:26

from django.conf import settings
from django.db import migrations


def update_cells(apps, schema_editor):
    Statistic = apps.get_model('dataviz', 'Statistic')
    ChartNgCell = apps.get_model('dataviz', 'ChartNgCell')
    bijoe_sites = settings.KNOWN_SERVICES.get('bijoe', {})

    for cell in ChartNgCell.objects.filter(statistic__isnull=True):
        if not cell.data_reference or not cell.cached_json:
            continue
        site_slug, slug = cell.data_reference.split(':')
        statistic, _ = Statistic.objects.get_or_create(
            slug=slug,
            site_slug=site_slug,
            service_slug='bijoe',
            defaults={
                'label': cell.cached_json['name'],
                'url': cell.cached_json['data-url'],
                'site_title': bijoe_sites.get(site_slug, {}).get('title'),
            },
        )
        cell.statistic = statistic
        cell.save()


class Migration(migrations.Migration):
    dependencies = [
        ('dataviz', '0012_auto_20201126_1557'),
    ]

    operations = [
        migrations.RunPython(update_cells, migrations.RunPython.noop),
    ]
