# Generated by Django 1.11.12 on 2019-03-28 10:11

import django.db.models.deletion
from django.db import migrations, models
from django.db.models import JSONField


class Migration(migrations.Migration):
    dependencies = [
        ('data', '0036_page_sub_slug'),
        ('dataviz', '0009_auto_20190617_1214'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChartNgCell',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('placeholder', models.CharField(max_length=20)),
                ('order', models.PositiveIntegerField()),
                ('slug', models.SlugField(blank=True, verbose_name='Slug')),
                (
                    'extra_css_class',
                    models.CharField(
                        blank=True, max_length=100, verbose_name='Extra classes for CSS styling'
                    ),
                ),
                ('public', models.BooleanField(default=True, verbose_name='Public')),
                (
                    'restricted_to_unlogged',
                    models.BooleanField(default=False, verbose_name='Restrict to unlogged users'),
                ),
                ('last_update_timestamp', models.DateTimeField(auto_now=True)),
                ('data_reference', models.CharField(max_length=150, verbose_name='Data')),
                ('title', models.CharField(blank=True, max_length=150, verbose_name='Title')),
                ('cached_json', JSONField(blank=True, default=dict)),
                (
                    'chart_type',
                    models.CharField(
                        choices=[
                            (b'bar', 'Bar'),
                            (b'horizontal-bar', 'Horizontal Bar'),
                            (b'stacked-bar', 'Stacked Bar'),
                            (b'line', 'Line'),
                            (b'pie', 'Pie'),
                            (b'dot', 'Dot'),
                            (b'table', 'Table'),
                        ],
                        default=b'bar',
                        max_length=20,
                        verbose_name='Chart Type',
                    ),
                ),
                (
                    'height',
                    models.CharField(
                        choices=[
                            (b'150', 'Short (150px)'),
                            (b'250', 'Average (250px)'),
                            (b'350', 'Tall (350px)'),
                        ],
                        default=b'250',
                        max_length=20,
                        verbose_name='Height',
                    ),
                ),
                ('groups', models.ManyToManyField(blank=True, to='auth.Group', verbose_name='Roles')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data.Page')),
            ],
            options={
                'verbose_name': 'Chart',
            },
        ),
        migrations.AlterModelOptions(
            name='chartcell',
            options={'verbose_name': 'Chart (legacy)'},
        ),
    ]
