# Generated by Django 4.2.18 on 2025-07-06 11:44

from django.db import migrations


def forward(apps, schema_editor):
    tile_class = apps.get_model('dashboard', 'Tile')

    instances = []
    for instance in tile_class.objects.all():
        instance.dashboard_id = instance.dashboard_temp_id
        instances.append(instance)
    tile_class.objects.bulk_update(instances, ['dashboard_id'])


class Migration(migrations.Migration):

    dependencies = [
        ('dashboard', '0012_tile_dashboard'),
    ]

    operations = [
        migrations.RunPython(forward, reverse_code=migrations.RunPython.noop),
    ]
