# Generated by Django 4.2.18 on 2025-07-06 11:23

from django.db import migrations

from combo.utils.migrations import UnivercellMigration


class DashboardUnivercellMigration(UnivercellMigration):
    bulk_create = False

    def __init__(self):
        super().__init__('dashboard', 'combo.apps.dashboard.models.DashboardCell')

    def forward(self, apps, schema_editor):
        self.tile_class = apps.get_model('dashboard', 'Tile')
        super().forward(apps, schema_editor)

    def forward_instance(self, new_class, real_class, instance):
        old_tiles = list(self.tile_class.objects.filter(dashboard_temp_id=instance.id))
        instance = super().forward_instance(new_class, real_class, instance)
        for tile in old_tiles:
            tile.dashboard_temp_id = instance.id
        self.tile_class.objects.bulk_update(old_tiles, ['dashboard_temp_id'])
        return instance


class Migration(migrations.Migration):

    dependencies = [
        ('data', '0075_univercell'),
        ('auth', '0012_alter_user_first_name_max_length'),
        ('dashboard', '0010_tile_dashboard_temp_id'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='DashboardCell',
            new_name='OldDashboardCell',
        ),
        migrations.CreateModel(
            name='DashboardCell',
            fields=[],
            options={
                'verbose_name': 'Dashboard',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('data.univercell',),
        ),
        migrations.AlterModelTable(
            name='olddashboardcell',
            table='dashboard_dashboardcell',
        ),
        DashboardUnivercellMigration(),
    ]
