# combo - content management system
# Copyright (C) 2014-2015  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import path, re_path

from combo.urls_utils import manager_required

from .views import ajax_gauge_count, dataviz_choices, dataviz_graph, dataviz_graph_export

urlpatterns = [
    path('ajax/gauge-count/<int:cell>/', ajax_gauge_count, name='combo-ajax-gauge-count'),
    re_path(r'^api/dataviz/graph/(?P<cell>[\w_-]+)/$', dataviz_graph, name='combo-dataviz-graph'),
    re_path(
        r'^dataviz/graph/(?P<cell>[\w_-]+)/export/$', dataviz_graph_export, name='combo-dataviz-graph-export'
    ),
    path(
        'api/dataviz/graph/<int:cell_id>/<filter_id>/ajax-choices',
        manager_required(dataviz_choices),
        name='combo-dataviz-choices',
    ),
]
