# combo - content management system
# Copyright (C) 2015-2025  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import include, path, re_path

from combo.urls_utils import decorated_includes, manager_required

from .manager_views import ManagerHomeView, save_options_view

appearance_manager_urls = [
    path('', ManagerHomeView.as_view(), name='appearance-manager-homepage'),
    path('save-options', save_options_view, name='appearance-manager-save-options'),
]

urlpatterns = [
    re_path(r'^manage/appearance/', decorated_includes(manager_required, include(appearance_manager_urls))),
]
