# Generated by Django 1.11.17 on 2020-02-19 08:20

from django.db import migrations, transaction
from django.db.migrations.operations.base import Operation
from django.db.utils import InternalError, OperationalError, ProgrammingError


class TextSearchConfiguration(Operation):
    reversible = True

    def state_forwards(self, app_label, state):
        pass

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        if schema_editor.connection.vendor != 'postgresql':
            return
        try:
            with transaction.atomic():
                try:
                    schema_editor.execute('CREATE EXTENSION IF NOT EXISTS unaccent SCHEMA public')
                except (OperationalError, ProgrammingError):
                    # OperationalError if the extension is not available
                    # ProgrammingError in case of denied permission
                    dictionaries = 'french_stem'
                else:
                    dictionaries = 'public.unaccent, french_stem'
        except InternalError:
            # InternalError (current transaction is aborted, commands ignored
            # until end of transaction block) would be raised when django-
            # tenant-schemas set search_path.
            pass
        schema_editor.execute('CREATE TEXT SEARCH CONFIGURATION french_unaccent( COPY = french )')
        schema_editor.execute(
            'ALTER TEXT SEARCH CONFIGURATION french_unaccent '
            'ALTER MAPPING FOR hword, hword_part, word '
            'WITH %s' % dictionaries
        )

    def database_backwards(self, app_label, schema_editor, from_state, to_state):
        if schema_editor.connection.vendor != 'postgresql':
            return
        schema_editor.execute('DROP TEXT SEARCH CONFIGURATION french_unaccent')

    def describe(self):
        return 'Creates unaccent french text search configuration'


class Migration(migrations.Migration):
    dependencies = [
        ('search', '0006_indexedcell'),
    ]

    operations = [
        TextSearchConfiguration(),
    ]
