# Generated by Django 2.2.19 on 2022-01-18 10:03

from django.db import migrations


def update_time_intervals(apps, schema_editor):
    ChartNgCell = apps.get_model('dataviz', 'ChartNgCell')

    for cell in ChartNgCell.objects.all():
        save = False
        for param in cell.filter_params:
            if param == 'time_interval' and cell.filter_params[param].startswith('_'):
                cell.filter_params[param] = cell.filter_params[param][1:]
                save = True
        if save:
            cell.save()


class Migration(migrations.Migration):
    dependencies = [
        ('dataviz', '0019_auto_20211006_1525'),
    ]

    operations = [
        migrations.RunPython(update_time_intervals, migrations.RunPython.noop),
    ]
