# Generated by Django 3.2.18 on 2024-04-29 12:05

from django.db import migrations


def remove_all_forms_option(apps, schema_editor):
    ChartNgCell = apps.get_model('dataviz', 'ChartNgCell')

    for cell in ChartNgCell.objects.filter(statistic__slug='forms_counts'):
        form_filter = cell.filter_params.get('form')
        if not form_filter or not isinstance(form_filter, list):
            continue

        try:
            form_filter.remove('_all')
        except ValueError:
            continue

        cell.save()


class Migration(migrations.Migration):
    dependencies = [
        ('dataviz', '0029_chartngcell_display_total'),
    ]

    operations = [
        migrations.RunPython(remove_all_forms_option, migrations.RunPython.noop),
    ]
