# Generated by Django 1.11.18 on 2020-10-29 15:39

from django.conf import settings
from django.db import migrations
from django.utils import translation
from django.utils.translation import gettext as _


def translate_holidays_exceptions(apps, schema_editor):
    labels = [
        'All Saints Day',
        'Armistice Day',
        'Ascension Thursday',
        'Assumption of Mary to Heaven',
        'Bastille Day',
        'Christmas Day',
        'Easter Monday',
        'Labour Day',
        'New year',
        'Victory in Europe Day',
        'Whit Monday',
    ]
    TimePeriodException = apps.get_model('agendas', 'TimePeriodException')
    qs = TimePeriodException.objects.filter(source__settings_slug__isnull=False)
    with translation.override(settings.LANGUAGE_CODE):
        for label in labels:
            qs.filter(label=label).update(label=_(label))


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0068_remove_timeperiodexception_external'),
    ]

    operations = [
        migrations.RunPython(translate_holidays_exceptions, migrations.RunPython.noop),
    ]
