# chrono - agendas system
# Copyright (C) 2021  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.core.management.base import BaseCommand

from chrono.agendas.models import Agenda


class Command(BaseCommand):
    help = 'Update event recurrences to reflect exceptions'

    def handle(self, **options):
        agendas = Agenda.objects.filter(kind='events', event__recurrence_days__isnull=False).distinct()
        for agenda in agendas:
            agenda.update_event_recurrences()
