import datetime

import pytest
from django.core.management import call_command
from django.utils.timezone import now

from chrono.manager.models import ManagerAsyncJob

pytestmark = pytest.mark.django_db


def test_clear_jobs():
    ManagerAsyncJob.objects.create(status='registered')
    ManagerAsyncJob.objects.create(status='running')
    failed_job = ManagerAsyncJob.objects.create(status='failed')
    completed_job = ManagerAsyncJob.objects.create(status='completed')

    # too soon
    call_command('clear_jobs')
    assert ManagerAsyncJob.objects.count() == 4

    # still too soon
    ManagerAsyncJob.objects.update(last_update_timestamp=now() - datetime.timedelta(days=2, minutes=-1))
    call_command('clear_jobs')
    assert ManagerAsyncJob.objects.count() == 4

    # ok, two days after job is completed, but too soon for errors
    ManagerAsyncJob.objects.update(last_update_timestamp=now() - datetime.timedelta(days=2))
    call_command('clear_jobs')
    assert ManagerAsyncJob.objects.count() == 3
    assert ManagerAsyncJob.objects.filter(pk=completed_job.pk).exists() is False

    # too soon for errors
    ManagerAsyncJob.objects.update(last_update_timestamp=now() - datetime.timedelta(days=10, minutes=-1))
    call_command('clear_jobs')
    assert ManagerAsyncJob.objects.count() == 3

    # ok, ten days after job has failed
    ManagerAsyncJob.objects.update(last_update_timestamp=now() - datetime.timedelta(days=10))
    call_command('clear_jobs')
    assert ManagerAsyncJob.objects.count() == 2
    assert ManagerAsyncJob.objects.filter(pk=completed_job.pk).exists() is False
    assert ManagerAsyncJob.objects.filter(pk=failed_job.pk).exists() is False
