# Generated by Django 2.2.19 on 2022-03-03 16:03

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

from chrono.agendas.models import WEEKDAY_CHOICES


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0109_auto_20220203_1051'),
    ]

    operations = [
        migrations.CreateModel(
            name='Person',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('user_external_id', models.CharField(max_length=250, unique=True)),
                ('name', models.CharField(max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='SharedCustodyAgenda',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('children', models.ManyToManyField(related_name='agendas', to='agendas.Person')),
                (
                    'first_guardian',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='agendas.Person',
                        verbose_name='First guardian',
                    ),
                ),
                (
                    'second_guardian',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='agendas.Person',
                        verbose_name='Second guardian',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='SharedCustodyRule',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'days',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(choices=WEEKDAY_CHOICES),
                        size=None,
                        verbose_name='Days',
                    ),
                ),
                (
                    'weeks',
                    models.CharField(
                        blank=True,
                        choices=[('', 'All'), ('even', 'Even'), ('odd', 'Odd')],
                        max_length=16,
                        verbose_name='Weeks',
                    ),
                ),
                (
                    'agenda',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='rules',
                        to='agendas.SharedCustodyAgenda',
                    ),
                ),
                (
                    'guardian',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='agendas.Person',
                        verbose_name='Guardian',
                    ),
                ),
            ],
            options={
                'ordering': ['days__0', 'weeks'],
            },
        ),
        migrations.CreateModel(
            name='SharedCustodyPeriod',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('date_start', models.DateField(verbose_name='Start')),
                ('date_end', models.DateField(verbose_name='End')),
                (
                    'agenda',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='periods',
                        to='agendas.SharedCustodyAgenda',
                    ),
                ),
                (
                    'guardian',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name='+', to='agendas.Person'
                    ),
                ),
            ],
            options={
                'ordering': ['date_start'],
            },
        ),
    ]
